PdependsOnH()
FUNCTION PdependsOnH()
    SYSTEM(BackGround=995, FontSize=19)
    DO step = 1, 81                ! from 1 to 81
        height = (step - 1) * 100    ! from 0 to 8000
        $HP(step, 1) = height
        $HP(step, 2) = BarometricPressure(height)
    ENDDO
    F2()
    F3()
    F4()
END

FUNCTION F2() ! standard loop graph
    DLG(R=2,C=4,BackG=99, AXis=3, X=1,MIN=0,MAX=8000,TIt='using standard loop',   Y=1,MIN=300,MAX=1100)
    DO i = 0, 10
        height = 1000 * i
        pressure = BarometricPressure(height)
        LINE(AX=3, X=height, Y=pressure, Symbol='🞉', Draw=9)
    ENDDO
END

FUNCTION F3() ! internal $ loop variable
    DLG(R=2,C=4,BackG=990, AXis=4, X=1,TI='altitude/m',MAX=8000,TIt='using built-in loop variable $',   Y=1,TI='pressure/hPa',MIN=300,MAX=1100)
    LINE(AX=4, X=$HP($,1), Y=$HP($,2), Symbol='.', Draw=-9)
END

FUNCTION F4() ! show p(h) array and explain
    DLG(Nr=5, L=1/2,T=1/2, Array=$HP, TItle=',height / m,barometric pressure / hPa', SCROLl=100)
    DLG(L=0,W=1/2, B='OK, show script', B='Quit HicEst', XEQ='SYSTEM(QUIT=1)', E='#Explain')
    DLG(Kill=3,Kill=4, Kill=5)
END

FUNCTION BarometricPressure(h)
    a = 0.0065    ! K/m
    T0 = 15 + 273 ! K
    M = 0.02896   ! kg/mol
    g = 9.81      ! m/s2
    R = 8.314     ! J/K/mol = kg*m/s2 /K/mol
    P0 = 1013     ! hPa = h N/m2 = h m*kg/s2 /m2
    P = P0 * ((1 - a*h/T0) ^ (M*g/R/a))
    RETURN P
END
#Explain
We calculate the atmosheric pressure as a function of altitude

You need to know:
.	Line 1 is always executed at start.
.		A FUNCTION call auto-runs the script.
.		This script starts with FUNCTION PdependsOnH()

.	To see the code: hit ESCAPE

.	All 4 windows are modeless: code does not wait for closure
.	NR=.. or AX=.. assign the numbers for modeless windows

A matrix $HP with 81 rows and 2 columns is built
.	The $-prefix generates a global variable.
.	A matrix column can be either numeric or text

Functions return a value with the RETURN ... statement

Useful to know:
.	Rows=r and Cols=c divide the screen in r*c areas
.		Nr=wdwNr or AX=axNr will be within this screen area.
.	Press F1 over an item to show its value.
.	Vectors and matrices are edited with the DLG function.
.	Define FUNCTIONs should be at the end of the code.
###
